/*
    Mega Bezel - Creates a graphic treatment for the game play area to give a retro feel
    Copyright (C) 2019-2022 HyperspaceMadness - HyperspaceMadness@outlook.com

    Incorporates much great feedback from the libretro forum, and thanks 
    to Hunterk who helped me get started

    See more at the libretro forum
    https://forums.libretro.com/t/hsm-mega-bezel-reflection-shader-feedback-and-updates

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see [http://www.gnu.org/licenses/].
*/

layout(std140, set = 0, binding = 0) uniform UBO
{
	mat4 MVP;
    vec4 SourceSize;
	vec4 OriginalSize;
	vec4 CorePassSize;
	vec4 CorePassFeedbackSize;
	vec4 OutputSize;
	vec4 FinalViewportSize;
	vec4 NegativeCropAddedPassSize;
	vec4 DerezedPassSize;
	int FrameDirection;
	uint FrameCount;

	float HSM_RESOLUTION_DEBUG_ON;
	float HSM_SINDEN_BORDER_ON;
	float HSM_SINDEN_BORDER_OPACITY;
float HSM_SINDEN_BORDER_BRIGHTNESS;
float HSM_SINDEN_AMBIENT_LIGHTING;
	float HSM_SINDEN_BORDER_THICKNESS;
float HSM_SINDEN_BORDER_EMPTY_TUBE_COMPENSATION;
	float HSM_CACHE_GRAPHICS_ON;
	float HSM_CACHE_UPDATE_INDICATOR_MODE;

	// Graphics Brightness
	float HSM_GLOBAL_GRAPHICS_BRIGHTNESS;
	float HSM_STATIC_LAYERS_GAMMA;

	// Night Lighting
	float HSM_AMBIENT_LIGHTING_OPACITY;
	float HSM_AMBIENT1_OPACITY;
	float HSM_AMBIENT2_OPACITY;
	float HSM_AMBIENT_LIGHTING_SWAP_IMAGE_MODE;

	float HSM_AMBIENT1_HUE;
	float HSM_AMBIENT1_SATURATION;
	float HSM_AMBIENT1_VALUE;
	float HSM_AMBIENT1_CONTRAST;
	float HSM_AMBIENT1_SCALE_KEEP_ASPECT;
	float HSM_AMBIENT1_SCALE_INHERIT_MODE;
	float HSM_AMBIENT1_SCALE;
	float HSM_AMBIENT1_SCALE_X;
	float HSM_AMBIENT1_ROTATE;
	float HSM_AMBIENT1_MIRROR_HORZ;
	float HSM_AMBIENT1_POS_INHERIT_MODE;
	float HSM_AMBIENT1_POSITION_X;
	float HSM_AMBIENT1_POSITION_Y;
	float HSM_AMBIENT1_DITHERING_SAMPLES;

	float HSM_AMBIENT2_HUE;
	float HSM_AMBIENT2_SATURATION;
	float HSM_AMBIENT2_VALUE;
	float HSM_AMBIENT2_CONTRAST;
	float HSM_AMBIENT2_SCALE_KEEP_ASPECT;
	float HSM_AMBIENT2_SCALE_INHERIT_MODE;
	float HSM_AMBIENT2_SCALE;
	float HSM_AMBIENT2_SCALE_X;
	float HSM_AMBIENT2_ROTATE;
	float HSM_AMBIENT2_MIRROR_HORZ;
	float HSM_AMBIENT2_POS_INHERIT_MODE;
	float HSM_AMBIENT2_POSITION_X;
	float HSM_AMBIENT2_POSITION_Y;

	//    Zoom & Pan
	float HSM_VIEWPORT_ZOOM;
	float HSM_VIEWPORT_POSITION_X;
	float HSM_VIEWPORT_POSITION_Y;
	float HSM_VIEWPORT_ZOOM_MASK;
	
	//    FLIP & ROTATE
	float HSM_FLIP_VIEWPORT_VERTICAL;
	float HSM_FLIP_VIEWPORT_HORIZONTAL;
	float HSM_FLIP_CORE_VERTICAL;
	float HSM_FLIP_CORE_HORIZONTAL;
	float HSM_ROTATE_CORE_IMAGE;

	//    ASPECT RATIO
	float HSM_ASPECT_RATIO_ORIENTATION;
	float HSM_ASPECT_RATIO_MODE;
	float HSM_ASPECT_RATIO_EXPLICIT;

	//    SCALING
	float HSM_INT_SCALE_MODE;
    float HSM_INT_SCALE_MULTIPLE_OFFSET;
	float HSM_INT_SCALE_MULTIPLE_OFFSET_LONG;
	float HSM_INT_SCALE_MAX_HEIGHT;
	float HSM_VERTICAL_PRESET;
	float HSM_NON_INTEGER_SCALE;

	float HSM_USE_PHYSICAL_SIZE_FOR_NON_INTEGER;
	float HSM_PHYSICAL_MONITOR_ASPECT_RATIO;
	float HSM_PHYSICAL_MONITOR_DIAGONAL_SIZE;
	float HSM_PHYSICAL_SIM_TUBE_DIAGONAL_SIZE;


	//    Extended Scale
	float HSM_USE_IMAGE_FOR_PLACEMENT;
	float HSM_PLACEMENT_IMAGE_USE_HORIZONTAL;
	float HSM_PLACEMENT_IMAGE_MODE;
	float HSM_NON_INTEGER_SCALE_OFFSET;
	float HSM_USE_SNAP_TO_CLOSEST_INT_SCALE;
	float HSM_SNAP_TO_CLOSEST_INT_SCALE_TOLERANCE;

	//    Position
	float HSM_SCREEN_POSITION_X;
	float HSM_SCREEN_POSITION_Y;

	//    CROPPING
	float HSM_CROP_MODE;
	float HSM_CROP_PERCENT_ZOOM;
	float HSM_CROP_PERCENT_TOP;
	float HSM_CROP_PERCENT_BOTTOM;
	float HSM_CROP_PERCENT_LEFT;
	float HSM_CROP_PERCENT_RIGHT;
	float HSM_CROP_BLACK_THRESHOLD;

	//    SCANLINES
	float HSM_SCANLINE_DIRECTION;

	//    CORE RES SAMPLING
	float HSM_CORE_RES_SAMPLING_MULT_SCANLINE_DIR;
	float HSM_DOWNSAMPLE_BLUR_SCANLINE_DIR;
	float HSM_CORE_RES_SAMPLING_MULT_OPPOSITE_DIR;
	float HSM_DOWNSAMPLE_BLUR_OPPOSITE_DIR;
	float HSM_CORE_RES_SAMPLING_SHIFT_OPPOSITE_DIR;

	//    INTERLACING
	float HSM_INTERLACE_TRIGGER_RES;
	float HSM_INTERLACE_MODE;
	float HSM_INTERLACE_EFFECT_SMOOTHNESS_INTERS;
	float HSM_INTERLACE_SCANLINE_EFFECT;
	float iscans;

	//    FAKE SCANLINES
	float HSM_FAKE_SCANLINE_MODE;
	float HSM_FAKE_SCANLINE_OPACITY;
	float HSM_FAKE_SCANLINE_RES_MODE;
	float HSM_FAKE_SCANLINE_RES;
	float HSM_FAKE_SCANLINE_INT_SCALE;
	float HSM_FAKE_SCANLINE_ROLL;
	float HSM_FAKE_SCANLINE_CURVATURE;
	float HSM_FAKE_SCANLINE_BRIGHTNESS_CUTOFF;

	//    DUAL SCREEN
	float HSM_DUALSCREEN_MODE;
	float HSM_DUALSCREEN_CORE_IMAGE_SPLIT_MODE;
	float HSM_DUALSCREEN_CORE_IMAGE_SWAP_SCREENS;
	float HSM_DUALSCREEN_CORE_IMAGE_SPLIT_OFFSET;
	float HSM_DUALSCREEN_VIEWPORT_SPLIT_LOCATION;
	float HSM_DUALSCREEN_SHIFT_POSITION_WITH_SCALE;
	float HSM_DUALSCREEN_POSITION_OFFSET_BETWEEN_SCREENS;
	float HSM_2ND_SCREEN_ASPECT_RATIO_MODE;
	float HSM_2ND_SCREEN_INDEPENDENT_SCALE;
	float HSM_2ND_SCREEN_SCALE_OFFSET;
	float HSM_2ND_SCREEN_POS_X;
	float HSM_2ND_SCREEN_POS_Y;
	float HSM_2ND_SCREEN_CROP_PERCENT_ZOOM;
	float HSM_2ND_SCREEN_CROP_PERCENT_TOP;
	float HSM_2ND_SCREEN_CROP_PERCENT_BOTTOM;
	float HSM_2ND_SCREEN_CROP_PERCENT_LEFT;
	float HSM_2ND_SCREEN_CROP_PERCENT_RIGHT;


	//    CURVATURE
	float HSM_CURVATURE_MODE;
	float HSM_CURVATURE_2D_SCALE_LONG_AXIS;
	float HSM_CURVATURE_2D_SCALE_SHORT_AXIS;
	float HSM_CURVATURE_3D_RADIUS;
	float HSM_CURVATURE_3D_VIEW_DIST;
	float HSM_CURVATURE_3D_TILT_ANGLE_X;
	float HSM_CURVATURE_3D_TILT_ANGLE_Y;
	float HSM_CRT_CURVATURE_SCALE;

	//    SIGNAL NOISE
	float HSM_SIGNAL_NOISE_ON;
	float HSM_SIGNAL_NOISE_AMOUNT;
float HSM_SIGNAL_NOISE_BLACK_LEVEL;
	float HSM_SIGNAL_NOISE_SIZE_MODE;
	float HSM_SIGNAL_NOISE_SIZE_MULT;
	float HSM_SIGNAL_NOISE_TYPE;

	//    ANTI-FLICKER
	float HSM_ANTI_FLICKER_ON;
	float HSM_ANTI_FLICKER_THRESHOLD;
	
	//    CRT vs ORIGINAL A/B TESTING
	float HSM_AB_COMPARE_SHOW_MODE;
	float HSM_AB_COMPARE_AREA;
	float HSM_AB_COMPARE_FREEZE_CRT_TUBE;
	float HSM_AB_COMPARE_FREEZE_GRAPHICS;
	float HSM_AB_COMPARE_SPLIT_AREA;
	float HSM_AB_COMPARE_SPLIT_POSITION;

	// Show Pass
	float HSM_SHOW_PASS_INDEX;
float HSM_SHOW_PASS_ALPHA;
	float HSM_SHOW_PASS_APPLY_SCREEN_COORD;

	float HSM_SCREEN_VIGNETTE_ON;
	float HSM_SCREEN_VIGNETTE_DUALSCREEN_VIS_MODE;
	float HSM_SCREEN_VIGNETTE_STRENGTH;
	float HSM_SCREEN_VIGNETTE_POWER;
	float HSM_SCREEN_VIGNETTE_IN_REFLECTION;
	
	//    Monochrome
	float HSM_MONOCHROME_MODE;
	float HSM_MONOCHROME_BRIGHTNESS;
	float HSM_MONOCHROME_GAMMA;
	float HSM_MONOCHROME_HUE_OFFSET;
	float HSM_MONOCHROME_SATURATION;
	float HSM_MONOCHROME_DUALSCREEN_VIS_MODE;

	//    Reflection Transform
	// float HSM_SCREEN_REFLECTION_FOLLOW_DIFFUSE_THICKNESS;
	float HSM_SCREEN_REFLECTION_SCALE;
	float HSM_SCREEN_REFLECTION_POS_X;
	float HSM_SCREEN_REFLECTION_POS_Y;
	
	// float HSM_PHOSPHOR_PERSISTENCE_BLEND;
	// float HSM_PHOSPHOR_PERSISTENCE_RED;
	// float HSM_PHOSPHOR_PERSISTENCE_GREEN;
	// float HSM_PHOSPHOR_PERSISTENCE_BLUE;

	//    TUBE IMAGES
	float HSM_TUBE_DIFFUSE_MODE;
	float HSM_TUBE_DIFFUSE_IMAGE_DUALSCREEN_VIS_MODE;
	float HSM_TUBE_OPACITY;
	float HSM_TUBE_DIFFUSE_IMAGE_AMOUNT;
	float HSM_TUBE_DIFFUSE_IMAGE_HUE;
	float HSM_TUBE_DIFFUSE_IMAGE_COLORIZE_ON;
	float HSM_TUBE_DIFFUSE_IMAGE_SATURATION;
	float HSM_TUBE_DIFFUSE_IMAGE_BRIGHTNESS;
	float HSM_TUBE_DIFFUSE_IMAGE_GAMMA;
	float HSM_TUBE_DIFFUSE_IMAGE_AMBIENT_LIGHTING;
	float HSM_TUBE_DIFFUSE_IMAGE_AMBIENT2_LIGHTING;
	float HSM_TUBE_DIFFUSE_IMAGE_SCALE;
	float HSM_TUBE_DIFFUSE_IMAGE_SCALE_X;
	float HSM_TUBE_DIFFUSE_IMAGE_ROTATION;
	float HSM_TUBE_EMPTY_THICKNESS;
	float HSM_TUBE_EMPTY_THICKNESS_X_SCALE;
	float HSM_TUBE_DIFFUSE_FORCE_ASPECT;
	float HSM_TUBE_EXPLICIT_ASPECT;
	float HSM_SCREEN_CORNER_RADIUS_SCALE;

	float HSM_TUBE_COLORED_GEL_IMAGE_ON;
	float HSM_TUBE_COLORED_GEL_IMAGE_DUALSCREEN_VIS_MODE;
	float HSM_TUBE_COLORED_GEL_IMAGE_MULTIPLY_AMOUNT;
	float HSM_TUBE_COLORED_GEL_IMAGE_NORMAL_AMOUNT;
	float HSM_TUBE_COLORED_GEL_IMAGE_NORMAL_BRIGHTNESS;
	float HSM_TUBE_COLORED_GEL_IMAGE_NORMAL_VIGNETTE;
	float HSM_TUBE_COLORED_GEL_IMAGE_TRANSPARENCY_THRESHOLD;
	float HSM_TUBE_COLORED_GEL_IMAGE_ADDITIVE_AMOUNT;
	float HSM_SHOW_CRT_ON_TOP_OF_COLORED_GEL;

	float HSM_TUBE_SHADOW_IMAGE_ON;
	float HSM_TUBE_SHADOW_IMAGE_OPACITY;
	float HSM_TUBE_SHADOW_IMAGE_SCALE_X;
	float HSM_TUBE_SHADOW_IMAGE_SCALE_Y;
	float HSM_TUBE_SHADOW_IMAGE_POS_X;
	float HSM_TUBE_SHADOW_IMAGE_POS_Y;
	float HSM_TUBE_SHADOW_CURVATURE_SCALE;

	float HSM_TUBE_COLORED_GEL_IMAGE_AMBIENT_LIGHTING;
	float HSM_TUBE_COLORED_GEL_IMAGE_AMBIENT2_LIGHTING;
	float HSM_TUBE_COLORED_GEL_IMAGE_FAKE_SCANLINE_AMOUNT;
	float HSM_TUBE_COLORED_GEL_IMAGE_SCALE;
	float HSM_TUBE_COLORED_GEL_IMAGE_FLIP_HORIZONTAL;
	float HSM_TUBE_COLORED_GEL_IMAGE_FLIP_VERTICAL;	

	//    TUBE STATIC REFLECTION
	float HSM_TUBE_STATIC_REFLECTION_IMAGE_ON;
	float HSM_TUBE_STATIC_REFLECTION_IMAGE_DUALSCREEN_VIS_MODE;
	float HSM_TUBE_STATIC_REFLECTION_IMAGE_OPACITY;
	float HSM_TUBE_STATIC_OPACITY_DIFFUSE_MULTIPLY;
	float HSM_TUBE_STATIC_BLACK_LEVEL;
	float HSM_TUBE_STATIC_AMBIENT_LIGHTING;
	float HSM_TUBE_STATIC_AMBIENT2_LIGHTING;
	float HSM_TUBE_STATIC_SCALE;
	float HSM_TUBE_STATIC_SCALE_X;
	float HSM_TUBE_STATIC_POS_X;
	float HSM_TUBE_STATIC_POS_Y;
	float HSM_TUBE_STATIC_SHADOW_OPACITY;
	float HSM_TUBE_STATIC_DITHER_SAMPLES;
	float HSM_TUBE_STATIC_DITHER_DISTANCE;
	float HSM_TUBE_STATIC_DITHER_AMOUNT;

	// CRT Screen
	// These names are inconsistent with the general naming on purpose
	// They match the namse in Guest's shader
	float HSM_CRT_BLEND_MODE;
	float HSM_CRT_BLEND_AMOUNT;
	float HSM_CRT_SCREEN_BLEND_MODE;

	//    Screen Vignette
	//    SCREEN BLACK EDGE
	float HSM_GLOBAL_CORNER_RADIUS;
	float HSM_TUBE_BLACK_EDGE_CORNER_RADIUS_SCALE;
	float HSM_TUBE_BLACK_EDGE_SHARPNESS;
	float HSM_TUBE_BLACK_EDGE_CURVATURE_SCALE;
	float HSM_TUBE_BLACK_EDGE_THICKNESS;
	float HSM_TUBE_BLACK_EDGE_THICKNESS_X_SCALE;

	//    Bezel Independent Scale
	float HSM_BZL_USE_INDEPENDENT_SCALE;
	float HSM_BZL_INDEPENDENT_SCALE;
	float HSM_BZL_USE_INDEPENDENT_CURVATURE;
	float HSM_BZL_INDEPENDENT_CURVATURE_SCALE_LONG_AXIS;
	float HSM_BZL_INDEPENDENT_CURVATURE_SCALE_SHORT_AXIS;

	//    Bezel General
	float HSM_BZL_OPACITY;
	float HSM_BZL_BLEND_MODE;
	float HSM_BZL_WIDTH;
	float HSM_BZL_HEIGHT;
	float HSM_BZL_SCALE_OFFSET;
	float HSM_BZL_INNER_CURVATURE_SCALE;
	float HSM_BZL_INNER_CORNER_RADIUS_SCALE;

	//	Bezel Params not in Screen Scale
	float HSM_BZL_OUTER_CURVATURE_SCALE;
	float HSM_BZL_INNER_EDGE_THICKNESS;
	float HSM_BZL_INNER_EDGE_SHARPNESS;
	float HSM_BZL_OUTER_CORNER_RADIUS_SCALE;
	float HSM_BZL_INNER_EDGE_SHADOW;

	// Generated Bezel
	float HSM_BZL_COLOR_HUE;
	float HSM_BZL_COLOR_SATURATION;
	float HSM_BZL_COLOR_VALUE;
	float HSM_BZL_NOISE;
	float HSM_BZL_BRIGHTNESS;	
	float HSM_BZL_BRIGHTNESS_MULT_TOP;
	float HSM_BZL_BRIGHTNESS_MULT_BOTTOM;
	float HSM_BZL_BRIGHTNESS_MULT_SIDES;
	float HSM_BZL_BRIGHTNESS_MULT_SIDE_LEFT;
	float HSM_BZL_BRIGHTNESS_MULT_SIDE_RIGHT;
	float HSM_BZL_HIGHLIGHT;
	float HSM_BZL_AMBIENT_LIGHTING_MULTIPLIER;
	float HSM_BZL_AMBIENT2_LIGHTING_MULTIPLIER;

	// Generated Frame
	float HSM_FRM_USE_INDEPENDENT_COLOR;
	float HSM_FRM_COLOR_HUE;
	float HSM_FRM_COLOR_SATURATION;
	float HSM_FRM_COLOR_VALUE;
	float HSM_FRM_NOISE;
	float HSM_FRM_OUTER_CURVATURE_SCALE;
	float HSM_FRM_THICKNESS;
	float HSM_FRM_THICKNESS_SCALE_X;
	float HSM_FRM_OUTER_POS_Y;
	float HSM_FRM_INNER_EDGE_THICKNESS;
	float HSM_FRM_OUTER_EDGE_THICKNESS;
	float HSM_FRM_OUTER_EDGE_SHADING;
	float HSM_FRM_OUTER_CORNER_RADIUS;
	float HSM_BZL_OUTER_POSITION_Y;
	float HSM_FRM_SHADOW_OPACITY;
	float HSM_FRM_SHADOW_WIDTH;

	// Corner 
	float HSM_REFLECT_CORNER_FADE;
	float HSM_REFLECT_CORNER_INNER_SPREAD;
	float HSM_REFLECT_CORNER_OUTER_SPREAD;
	float HSM_REFLECT_CORNER_ROTATION_OFFSET_TOP;
	float HSM_REFLECT_CORNER_ROTATION_OFFSET_BOTTOM;
	float HSM_REFLECT_CORNER_SPREAD_FALLOFF;
	float HSM_REFLECT_CORNER_FADE_DISTANCE;

	// Reflection
	float HSM_REFLECT_GLOBAL_AMOUNT;
	float HSM_REFLECT_GLOBAL_GAMMA_ADJUST;

	float HSM_REFLECT_BEZEL_INNER_EDGE_AMOUNT;
	float HSM_REFLECT_BEZEL_INNER_EDGE_FULLSCREEN_GLOW;
	float HSM_REFLECT_FRAME_INNER_EDGE_AMOUNT;
	float HSM_REFLECT_FRAME_INNER_EDGE_SHARPNESS;
float HSM_REFLECT_SHOW_TUBE_FX_AMOUNT;
	float HSM_REFLECT_DIRECT_AMOUNT;
	float HSM_REFLECT_DIFFUSED_AMOUNT;
	float HSM_REFLECT_FULLSCREEN_GLOW;
	float HSM_REFLECT_FULLSCREEN_GLOW_GAMMA;

	float HSM_REFLECT_FADE_AMOUNT;
	float HSM_REFLECT_RADIAL_FADE_WIDTH;
	float HSM_REFLECT_RADIAL_FADE_HEIGHT;

	float HSM_REFLECT_LATERAL_OUTER_FADE_POSITION;
	float HSM_REFLECT_LATERAL_OUTER_FADE_DISTANCE;

	float HSM_REFLECT_NOISE_AMOUNT;
	float HSM_REFLECT_NOISE_SAMPLES;
	float HSM_REFLECT_NOISE_SAMPLE_DISTANCE;

	// Blur Stuff
	float HSM_REFLECT_BLUR_NUM_SAMPLES;
	float HSM_REFLECT_BLUR_FALLOFF_DISTANCE;
	float HSM_REFLECT_BLUR_MIN;
	float HSM_REFLECT_BLUR_MAX;
	
	float HSM_REFLECT_MASK_IMAGE_AMOUNT;
	float HSM_REFLECT_MASK_FOLLOW_LAYER;
	float HSM_REFLECT_MASK_FOLLOW_MODE;
	float HSM_REFLECT_MASK_BRIGHTNESS;
	float HSM_REFLECT_MASK_BLACK_LEVEL;
float HSM_REFLECT_MASK_MIPMAPPING_BLEND_BIAS;

	float HSM_GLASS_BORDER_ON;
	float HSM_REFLECT_VIGNETTE_AMOUNT;
	float HSM_REFLECT_VIGNETTE_SIZE;

	float HSM_POTATO_SHOW_BG_OVER_SCREEN;
	float HSM_POTATO_COLORIZE_CRT_WITH_BG;
	float HSM_POTATO_COLORIZE_BRIGHTNESS;
	float HSM_STANDARD_DECAL_SCALE_WITH_FRAME;
	float HSM_STANDARD_TOP_SCALE_WITH_FRAME;

	// Layer Order
	float HSM_BG_LAYER_ORDER;
	float HSM_VIEWPORT_VIGNETTE_LAYER_ORDER;
	float HSM_CRT_LAYER_ORDER;
	float HSM_DEVICE_LAYER_ORDER;
	float HSM_DEVICELED_LAYER_ORDER;
	float HSM_CAB_GLASS_LAYER_ORDER;
	float HSM_DECAL_LAYER_ORDER;
	float HSM_LED_LAYER_ORDER;
	float HSM_TOP_LAYER_ORDER;

	// Cutout
	float HSM_CUTOUT_ASPECT_MODE;
	float HSM_CUTOUT_EXPLICIT_ASPECT;
	float HSM_CUTOUT_FOLLOW_LAYER;
	float HSM_CUTOUT_FOLLOW_FULL_USES_ZOOM;
	float HSM_CUTOUT_SCALE;
	float HSM_CUTOUT_SCALE_X;
	float HSM_CUTOUT_CORNER_RADIUS;
	float HSM_CUTOUT_POS_X;
	float HSM_CUTOUT_POS_Y;

	// Background
	float HSM_BG_OPACITY;
	float HSM_BG_HUE;
	float HSM_BG_COLORIZE_ON;
	float HSM_BG_SATURATION;
	float HSM_BG_BRIGHTNESS;
	float HSM_BG_GAMMA;
	float HSM_BG_AMBIENT_LIGHTING_MULTIPLIER;
	float HSM_BG_AMBIENT2_LIGHTING_MULTIPLIER;
	float HSM_BG_APPLY_AMBIENT_IN_ADD_MODE;
	float HSM_BG_BLEND_MODE;
	float HSM_BG_SOURCE_MATTE_TYPE;
	float HSM_BG_MASK_MODE;
	float HSM_BG_CUTOUT_MODE;
	float HSM_BG_DUALSCREEN_VIS_MODE;
	float HSM_BG_FOLLOW_LAYER;
	float HSM_BG_FOLLOW_MODE;
	float HSM_BG_FOLLOW_FULL_USES_ZOOM;
	float HSM_BG_FILL_MODE;
	float HSM_BG_SPLIT_PRESERVE_CENTER;
	float HSM_BG_SPLIT_REPEAT_WIDTH;
	float HSM_BG_SCALE;
	float HSM_BG_SCALE_X;
	float HSM_BG_POS_X;
	float HSM_BG_POS_Y;
	float HSM_BG_WRAP_MODE;
	float HSM_BG_MIPMAPPING_BLEND_BIAS;

	// Background Vignette
	float HSM_VIEWPORT_VIGNETTE_OPACITY;
	float HSM_VIEWPORT_VIGNETTE_MASK_MODE;
	float HSM_VIEWPORT_VIGNETTE_CUTOUT_MODE;
	float HSM_VIEWPORT_VIGNETTE_FOLLOW_LAYER;
	float HSM_VIEWPORT_VIGNETTE_SCALE;
	float HSM_VIEWPORT_VIGNETTE_SCALE_X;
	float HSM_VIEWPORT_VIGNETTE_POS_X;
	float HSM_VIEWPORT_VIGNETTE_POS_Y;

	// LED
	float HSM_LED_OPACITY;
	float HSM_LED_HUE;
	float HSM_LED_COLORIZE_ON;
	float HSM_LED_SATURATION;
	float HSM_LED_BRIGHTNESS;
	float HSM_LED_GAMMA;
	float HSM_LED_AMBIENT_LIGHTING_MULTIPLIER;
	float HSM_LED_AMBIENT2_LIGHTING_MULTIPLIER;
	float HSM_LED_APPLY_AMBIENT_IN_ADD_MODE;
	float HSM_LED_BLEND_MODE;
	float HSM_LED_SOURCE_MATTE_TYPE;
	float HSM_LED_MASK_MODE;
	float HSM_LED_CUTOUT_MODE;
	float HSM_LED_DUALSCREEN_VIS_MODE;
	float HSM_LED_FOLLOW_LAYER;
	float HSM_LED_FOLLOW_MODE;
	float HSM_LED_FOLLOW_FULL_USES_ZOOM;
	float HSM_LED_FILL_MODE;
	float HSM_LED_SPLIT_PRESERVE_CENTER;
	float HSM_LED_SPLIT_REPEAT_WIDTH;
	float HSM_LED_SCALE;
	float HSM_LED_SCALE_X;
	float HSM_LED_POS_X;
	float HSM_LED_POS_Y;
	float HSM_LED_MIPMAPPING_BLEND_BIAS;

	// Device
	float HSM_DEVICE_OPACITY;
	float HSM_DEVICE_HUE;
	float HSM_DEVICE_COLORIZE_ON;
	float HSM_DEVICE_SATURATION;
	float HSM_DEVICE_BRIGHTNESS;
	float HSM_DEVICE_GAMMA;
	float HSM_DEVICE_AMBIENT_LIGHTING_MULTIPLIER;
	float HSM_DEVICE_AMBIENT2_LIGHTING_MULTIPLIER;
	float HSM_DEVICE_APPLY_AMBIENT_IN_ADD_MODE;
	float HSM_DEVICE_BLEND_MODE;
	float HSM_DEVICE_SOURCE_MATTE_TYPE;
	float HSM_DEVICE_MASK_MODE;
	float HSM_DEVICE_CUTOUT_MODE;
	float HSM_DEVICE_DUALSCREEN_VIS_MODE;
	float HSM_DEVICE_FOLLOW_LAYER;
	float HSM_DEVICE_FOLLOW_MODE;
	float HSM_DEVICE_FOLLOW_FULL_USES_ZOOM;
	float HSM_DEVICE_FILL_MODE;
	float HSM_DEVICE_SPLIT_PRESERVE_CENTER;
	float HSM_DEVICE_SPLIT_REPEAT_WIDTH;
	float HSM_DEVICE_SCALE;
	float HSM_DEVICE_SCALE_X;
	float HSM_DEVICE_POS_X;
	float HSM_DEVICE_POS_Y;
	float HSM_DEVICE_MIPMAPPING_BLEND_BIAS;

	// DEVICELED
	float HSM_DEVICELED_OPACITY;
	float HSM_DEVICELED_HUE;
	float HSM_DEVICELED_COLORIZE_ON;
	float HSM_DEVICELED_SATURATION;
	float HSM_DEVICELED_BRIGHTNESS;
	float HSM_DEVICELED_GAMMA;
	float HSM_DEVICELED_AMBIENT_LIGHTING_MULTIPLIER;
	float HSM_DEVICELED_AMBIENT2_LIGHTING_MULTIPLIER;
	float HSM_DEVICELED_APPLY_AMBIENT_IN_ADD_MODE;
	float HSM_DEVICELED_BLEND_MODE;
	float HSM_DEVICELED_SOURCE_MATTE_TYPE;
	float HSM_DEVICELED_MASK_MODE;
	float HSM_DEVICELED_CUTOUT_MODE;
	float HSM_DEVICELED_DUALSCREEN_VIS_MODE;
	float HSM_DEVICELED_FOLLOW_LAYER;
	float HSM_DEVICELED_FOLLOW_MODE;
	float HSM_DEVICELED_FOLLOW_FULL_USES_ZOOM;
	float HSM_DEVICELED_FILL_MODE;
	float HSM_DEVICELED_SPLIT_PRESERVE_CENTER;
	float HSM_DEVICELED_SPLIT_REPEAT_WIDTH;
	float HSM_DEVICELED_SCALE;
	float HSM_DEVICELED_SCALE_X;
	float HSM_DEVICELED_POS_X;
	float HSM_DEVICELED_POS_Y;
	float HSM_DEVICELED_MIPMAPPING_BLEND_BIAS;	

	// Generated Bezel & Frame
	float HSM_FRM_OPACITY;
	float HSM_FRM_BLEND_MODE;
	float HSM_FRM_TEXTURE_OPACITY;
	float HSM_FRM_TEXTURE_BLEND_MODE;

	// Decal
	float HSM_DECAL_OPACITY;
	float HSM_DECAL_HUE;
	float HSM_DECAL_COLORIZE_ON;
	float HSM_DECAL_SATURATION;
	float HSM_DECAL_BRIGHTNESS;
	float HSM_DECAL_GAMMA;
	float HSM_DECAL_AMBIENT_LIGHTING_MULTIPLIER;
	float HSM_DECAL_AMBIENT2_LIGHTING_MULTIPLIER;
	float HSM_DECAL_APPLY_AMBIENT_IN_ADD_MODE;
	float HSM_DECAL_BLEND_MODE;
	float HSM_DECAL_SOURCE_MATTE_TYPE;
	float HSM_DECAL_MASK_MODE;
	float HSM_DECAL_CUTOUT_MODE;
	float HSM_DECAL_DUALSCREEN_VIS_MODE;
	float HSM_DECAL_FOLLOW_LAYER;
	float HSM_DECAL_FOLLOW_MODE;
	float HSM_DECAL_FOLLOW_FULL_USES_ZOOM;
	float HSM_DECAL_FILL_MODE;
	float HSM_DECAL_SPLIT_PRESERVE_CENTER;
	float HSM_DECAL_SPLIT_REPEAT_WIDTH;
	float HSM_DECAL_SCALE;
	float HSM_DECAL_SCALE_X;
	float HSM_DECAL_POS_X;
	float HSM_DECAL_POS_Y;
	float HSM_DECAL_MIPMAPPING_BLEND_BIAS;

	// Cab Glass
	float HSM_CAB_GLASS_OPACITY;
	float HSM_CAB_GLASS_HUE;
	float HSM_CAB_GLASS_COLORIZE_ON;
	float HSM_CAB_GLASS_SATURATION;
	float HSM_CAB_GLASS_BRIGHTNESS;
	float HSM_CAB_GLASS_GAMMA;
	float HSM_CAB_GLASS_AMBIENT_LIGHTING_MULTIPLIER;
	float HSM_CAB_GLASS_AMBIENT2_LIGHTING_MULTIPLIER;
	float HSM_CAB_GLASS_APPLY_AMBIENT_IN_ADD_MODE;
	float HSM_CAB_GLASS_BLEND_MODE;
	float HSM_CAB_GLASS_SOURCE_MATTE_TYPE;
	float HSM_CAB_GLASS_MASK_MODE;
	float HSM_CAB_GLASS_CUTOUT_MODE;
	float HSM_CAB_GLASS_DUALSCREEN_VIS_MODE;
	float HSM_CAB_GLASS_FOLLOW_LAYER;
	float HSM_CAB_GLASS_FOLLOW_MODE;
	float HSM_CAB_GLASS_FOLLOW_FULL_USES_ZOOM;
	float HSM_CAB_GLASS_FILL_MODE;
	float HSM_CAB_GLASS_SPLIT_PRESERVE_CENTER;
	float HSM_CAB_GLASS_SPLIT_REPEAT_WIDTH;
	float HSM_CAB_GLASS_SCALE;
	float HSM_CAB_GLASS_SCALE_X;
	float HSM_CAB_GLASS_POS_X;
	float HSM_CAB_GLASS_POS_Y;
	float HSM_CAB_GLASS_MIPMAPPING_BLEND_BIAS;

	// Top Image
	float HSM_TOP_OPACITY;
	float HSM_TOP_HUE;
	float HSM_TOP_COLORIZE_ON;
	float HSM_TOP_SATURATION;
	float HSM_TOP_BRIGHTNESS;
	float HSM_TOP_GAMMA;
	float HSM_TOP_AMBIENT_LIGHTING_MULTIPLIER;
	float HSM_TOP_AMBIENT2_LIGHTING_MULTIPLIER;
	float HSM_TOP_APPLY_AMBIENT_IN_ADD_MODE;
	float HSM_TOP_BLEND_MODE;
	float HSM_TOP_SOURCE_MATTE_TYPE;
	float HSM_TOP_MASK_MODE;
	float HSM_TOP_CUTOUT_MODE;
	float HSM_TOP_DUALSCREEN_VIS_MODE;
	float HSM_TOP_FOLLOW_LAYER;
	float HSM_TOP_FOLLOW_MODE;
	float HSM_TOP_FOLLOW_FULL_USES_ZOOM;
	float HSM_TOP_FILL_MODE;
	float HSM_TOP_SPLIT_PRESERVE_CENTER;
	float HSM_TOP_SPLIT_REPEAT_WIDTH;
	float HSM_TOP_SCALE;
	float HSM_TOP_SCALE_X;
	float HSM_TOP_POS_X;
	float HSM_TOP_POS_Y;	
	float HSM_TOP_MIRROR_WRAP;
	float HSM_TOP_MIPMAPPING_BLEND_BIAS;

	float HSM_RENDER_SIMPLE_MODE;
	float HSM_RENDER_SIMPLE_MASK_TYPE;
	float HSM_LAYERING_DEBUG_MASK_MODE;

	float HSM_INTRO_LOGO_BLEND_MODE;
	float HSM_INTRO_LOGO_FLIP_VERTICAL;
	float HSM_INTRO_NOISE_BLEND_MODE;
	float HSM_INTRO_NOISE_HOLD;
	float HSM_INTRO_NOISE_FADE_OUT;
	float HSM_INTRO_SOLID_BLACK_HOLD;
	float HSM_INTRO_SOLID_BLACK_FADE_OUT;
	float HSM_INTRO_SOLID_COLOR_BLEND_MODE;
	float HSM_INTRO_LOGO_OVER_SOLID_COLOR;
	float HSM_INTRO_LOGO_PLACEMENT;
	float HSM_INTRO_LOGO_HEIGHT;
	float HSM_INTRO_LOGO_POS_X;
	float HSM_INTRO_LOGO_POS_Y;
	float HSM_INTRO_WHEN_TO_SHOW;
	float HSM_INTRO_SPEED;
	float HSM_INTRO_LOGO_WAIT;
	float HSM_INTRO_LOGO_FADE_IN;
	float HSM_INTRO_LOGO_HOLD;
	float HSM_INTRO_LOGO_FADE_OUT;
	float HSM_INTRO_SOLID_COLOR_HUE;
	float HSM_INTRO_SOLID_COLOR_SAT;
	float HSM_INTRO_SOLID_COLOR_VALUE;
	float HSM_INTRO_SOLID_COLOR_HOLD;
	float HSM_INTRO_SOLID_COLOR_FADE_OUT;

	// Guest-Dr-Venom Params
	float GAMMA_INPUT;
	float gamma_out;
	float post_br;
	float post_br_affect_black_level;

	float m_glow;
	float m_glow_low;
	float m_glow_high;
	float m_glow_dist;
	float m_glow_mask;
	float smask_mit;

	float glow;
	float bloom;
	float mask_bloom;
	float bloom_dist;
	float halation;


	float TATE;
	float IOS;
	float GDV_RASTER_BLOOM_ON;
	float OS;
	float BLOOM;
	float GDV_OVERSCAN;
float GDV_OVERSCAN_X;
float GDV_OVERSCAN_Y;
	float overscanX;
	float overscanY;
	float intres;
	float prescalex;
	float c_shape;
	float sborder;
	float csize;
	float bsize1;
	float warpX;
	float warpY;

	float gamma_c;
	float brightboost;
	float brightboost1;

	float blendMode;

	float gsl;
	float scanline1;
	float scanline2;
	float beam_min;
	float beam_max;
	float beam_size;
	float vertmask;
	float scans;
	float scan_falloff;
	float spike;
	float ring;
	float no_scanlines;
	float scangamma;

	float rolling_scan;

	float h_sharp;
	float s_sharp;
	float smart_ei;
	float ei_limit;
	float sth;

	float barspeed;
	float barintensity;
	float bardir;

	float shadowMask;
	float maskstr;
	float mcut;	
	float maskboost;
	float masksize;
	float masksizeautothreshold;
	float maskDark;
	float maskLight;
	float mask_gamma;
	float slotmask;
	float slotmask1;
	float slotwidth;
	float double_slot;
	float slotms;
	float mclip;
	float smoothmask;
	float mshift;
	float mask_layout;
	
	float GDV_DECONVERGENCE_ON;
	float decons;
	float deconrr;
	float deconrg;
	float deconrb;
	float deconrry;
	float deconrgy;
	float deconrby;	
	float deconsmooth;
	float dctypex;
	float dctypey; 
	float dcscalemode; 
	
	float GDV_NOISE_ON;
	float addnoised;
	float noisetype;
	float noiseresd;
	float noiseresd4kmult;

	// Grade Params
	float g_grade_on;
    float wp_temperature;
    float g_satr;
    float g_satg;
    float g_satb;

	// Grade Afterglow Params
    float AS;
    float asat;

	// Megatron Parameters
	float hcrt_h_size;
	float hcrt_v_size;
	float hcrt_h_cent;
	float hcrt_v_cent;
	float hcrt_pin_phase;
	float hcrt_pin_amp;

} global;

/////////////// DEFINES ///////////////

// Maximum Negative cropping fron each edge
// This means that the pass with the negative crop area 
// added needs to have twice this much added in each direction 
#define DEFAULT_CRT_GAMMA 2.4
#define DEFAULT_SRGB_GAMMA 2.2

#define DEFAULT_SCREEN_HEIGHT 0.8297
#define DEFAULT_SCREEN_HEIGHT_PORTRAIT_MULTIPLIER (DEFAULT_SCREEN_HEIGHT - 0.4792) / DEFAULT_SCREEN_HEIGHT

#define SHOW_ON_DUALSCREEN_MODE_BOTH 0
#define SHOW_ON_DUALSCREEN_MODE_SCREEN_1 1
#define SHOW_ON_DUALSCREEN_MODE_SCREEN_2 2

#define FOLLOW_LAYER_VIEWPORT 0
#define FOLLOW_LAYER_TUBE_DIFFUSE 1
#define FOLLOW_LAYER_BEZEL_OUTSIDE 2
#define FOLLOW_LAYER_BG 3
#define FOLLOW_LAYER_DEVICE 4
#define FOLLOW_LAYER_DECAL 5
#define FOLLOW_LAYER_CAB_GLASS 6
#define FOLLOW_LAYER_TOP 7

float FOLLOW_MODE_SCALE_AND_POS = 0;
float FOLLOW_MODE_EXACT = 1;

#define TEXTURE_ASPECT_MODE_VIEWPORT 0
#define TEXTURE_ASPECT_MODE_EXPLICIT 1
#define TEXTURE_ASPECT_MODE_4_3 2
#define TEXTURE_ASPECT_MODE_3_4 3
#define TEXTURE_ASPECT_MODE_16_9 4
#define TEXTURE_ASPECT_MODE_9_16 5

float NEGATIVE_CROP_EXPAND_MULTIPLIER = 0.5;
float MAX_NEGATIVE_CROP = 0.5;

// In square coordinate space
#define DEFAULT_UNCORRECTED_SCREEN_SCALE vec2(1.10585, 0.8296)
#define DEFAULT_UNCORRECTED_BEZEL_SCALE vec2(1.2050, 0.9110)

float DEFAULT_SCREEN_ASPECT = DEFAULT_UNCORRECTED_SCREEN_SCALE.x / DEFAULT_UNCORRECTED_SCREEN_SCALE.y;
float DEFAULT_BEZEL_ASPECT = DEFAULT_UNCORRECTED_BEZEL_SCALE.x / DEFAULT_UNCORRECTED_BEZEL_SCALE.y;

vec2 DEFAULT_SCREEN_SCALE = vec2(0);
vec2 DEFAULT_BEZEL_SCALE = vec2(0);

#define DEFAULT_SCREEN_CORNER_RADIUS 10

int INFOCACHE_MAX_INDEX = 4;

bool CACHE_INFO_CHANGED = false;
float CURRENT_FRAME_FROM_CACHE_INFO = 0;

float TUBE_DIFFUSE_MASK = 0;
float TUBE_MASK = 0;
float BEZEL_MASK = 0;
float INSIDE_BEZEL_MASK = 0;
float OUTSIDE_TUBE_MASK_FOR_IMAGE = 0;
float FRAME_MASK = 0;
float FRAME_MASK_FOR_IMAGE = 0;
float OUTSIDE_BEZEL_MASK = 0;
float OUTSIDE_FRAME_MASK_FOR_IMAGE = 0;
float OUTSIDE_FRAME_MASK = 0;
float CUTOUT_MASK = 0;

float SCREEN_INDEX = 1;

float SCREEN_ASPECT = 1;
vec2 SCREEN_SCALE = vec2(1);
vec2 SCREEN_SCALE_WITH_ZOOM = vec2(1);
vec2 SCREEN_POS_OFFSET = vec2(0.15);
vec2 SCREEN_SCALE_2ND_SCREEN = vec2(1);

vec2 SCREEN_POS_OFFSET_1ST_SCREEN = vec2(0.15);
vec2 SCREEN_POS_OFFSET_2ND_SCREEN = vec2(0.15);

vec2 VIEWPORT_SCALE = vec2(1);
vec2 VIEWPORT_POS = vec2(1);
vec2 TUBE_SCALE = vec2(1);
vec2 TUBE_DIFFUSE_SCALE = vec2(1);
float TUBE_DIFFUSE_ASPECT = 1;

vec2 TUBE_DIFFUSE_SCALE_1ST_SCREEN = vec2(1);
vec2 TUBE_DIFFUSE_SCALE_2ND_SCREEN = vec2(1);

vec2 FRAME_SCALE = vec2(1);

vec2 BEZEL_OUTSIDE_SCALE = vec2(0.5);
vec2 BACKGROUND_SCALE = vec2(0.5);
vec2 LED_SCALE = vec2(0.5);
vec2 DEVICE_SCALE = vec2(0.5);
vec2 DEVICELED_SCALE = vec2(0.5);
vec2 DECAL_SCALE = vec2(0.5);
vec2 CAB_GLASS_SCALE = vec2(0.5);
vec2 TOP_IMAGE_SCALE = vec2(0.5);

float AVERAGE_LUMA = 0;
float USE_VERTICAL_SCANLINES = 0;
float SAMPLING_SCANLINE_DIR_MULT = 0;
float SAMPLING_OPPOSITE_DIR_MULT = 0;

vec2 CORE_SIZE = vec2(1);

vec2 ROTATED_CORE_ORIGINAL_SIZE = vec2(1);
vec2 ROTATED_CORE_PREPPED_SIZE = vec2(1);
vec2 ROTATED_DEREZED_SIZE = vec2(1);

vec2 CROPPED_ROTATED_SIZE_WITH_RES_MULT = vec2(1);
vec2 CROPPED_ROTATED_SIZE_WITH_RES_MULT_FEEDBACK = vec2(1);
vec2 CROPPED_ROTATED_SIZE = vec2(1);
vec2 SAMPLE_AREA_START_PIXEL_COORD = vec2(1);

vec2 SCREEN_SIZE = vec2(1);

vec2 VIEWPORT_UNSCALED_COORD = vec2(0.5);
vec2 SCREEN_COORD = vec2(0.5);
vec2 TUBE_COORD = vec2(0.5);
vec2 TUBE_DIFFUSE_COORD = vec2(0.5);
vec2 TUBE_DIFFUSE_COORD_MIXED_POS = vec2(0.5);
vec2 BEZEL_OUTSIDE_COORD = vec2(0.5);
vec2 BACKGROUND_COORD = vec2(0.5);
vec2 DEVICE_COORD = vec2(0.5);
vec2 DEVICELED_COORD = vec2(0.5);
vec2 LED_COORD = vec2(0.5);
vec2 DECAL_COORD = vec2(0.5);
vec2 CAB_GLASS_COORD = vec2(0.5);
vec2 TOP_IMAGE_COORD = vec2(0.5);

vec2 SCREEN_CURVED_COORD = vec2(0.5);
vec2 TUBE_CURVED_COORD = vec2(0.5);
vec2 TUBE_DIFFUSE_CURVED_COORD = vec2(0.5);
vec2 BEZEL_OUTSIDE_CURVED_COORD = vec2(0.5);
vec2 FRAME_OUTSIDE_CURVED_COORD = vec2(0.5);

vec2 BACKGROUND_CURVED_COORD = vec2(0.5);
vec2 LED_CURVED_COORD = vec2(0.5);
vec2 DEVICE_CURVED_COORD = vec2(0.5);
vec2 DEVICELED_CURVED_COORD = vec2(0.5);
vec2 DECAL_CURVED_COORD = vec2(0.5);
vec2 CAB_GLASS_CURVED_COORD = vec2(0.5);
vec2 TOP_IMAGE_CURVED_COORD = vec2(0.5);

